/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.macker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.macker.ForkedMacker;
import org.codehaus.mojo.macker.Macker;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class MackerMojo
extends AbstractMojo {
    private File classesDirectory;
    private File testClassesDirectory;
    private String[] excludes;
    private String[] includes;
    private boolean includeTests;
    private File rulesDirectory;
    private File outputDirectory;
    private String outputName;
    private int maxmsg;
    private String print;
    private String anger;
    private String rule;
    private String[] rules = new String[0];
    private ResourceManager locator;
    private Map variables = new HashMap();
    private boolean verbose;
    private boolean failOnError;
    private boolean skip;
    private MavenProject project;
    private String maxmem;
    private List pluginClasspathList;
    private boolean quiet;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List files;
        if (this.skip) {
            return;
        }
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            if (!this.quiet) {
                this.getLog().info((CharSequence)"Not executing macker as the project is not a Java classpath-capable package");
            }
            return;
        }
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        if (null == this.rules || 0 == this.rules.length) {
            this.rules = new String[1];
            this.rules[0] = this.rule;
        }
        try {
            files = this.getFilesToProcess();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during Macker execution: error in file selection", (Exception)e);
        }
        if (files == null || files.size() == 0) {
            if (!this.quiet) {
                if (this.includeTests) {
                    this.getLog().info((CharSequence)("No class files in directories " + this.classesDirectory + ", " + this.testClassesDirectory));
                } else {
                    this.getLog().info((CharSequence)("No class files in specified directory " + this.classesDirectory));
                }
            }
        } else {
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException("Error during Macker execution: Could not create directory " + this.outputDirectory.getAbsolutePath());
            }
            File outputFile = new File(this.outputDirectory, this.outputName);
            this.launchMacker(outputFile, files);
        }
    }

    private void launchMacker(File outputFile, List files) throws MojoExecutionException, MojoFailureException {
        try {
            Macker macker = this.createMacker(outputFile);
            this.configureRules(macker);
            this.initMackerVariables(macker);
            this.specifyClassFilesToAnalyse(files, macker);
            macker.check();
            if (!this.quiet) {
                this.getLog().info((CharSequence)"Macker has not found any violation.");
            }
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
        catch (MojoFailureException ex) {
            this.getLog().warn((CharSequence)"Macker has detected violations. Please refer to the XML report for more information.");
            if (this.failOnError) {
                throw ex;
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error during Macker execution: " + ex.getMessage(), ex);
        }
    }

    private void specifyClassFilesToAnalyse(List files, Macker macker) throws IOException, MojoExecutionException {
        Iterator i = files.iterator();
        while (i.hasNext()) {
            macker.addClass((File)i.next());
        }
    }

    private void initMackerVariables(Macker macker) {
        if (this.variables != null && this.variables.size() > 0) {
            Iterator it = this.variables.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                macker.setVariable(key, (String)this.variables.get(key));
            }
        }
    }

    private void configureRules(Macker macker) throws IOException, MojoExecutionException {
        try {
            for (int i = 0; i < this.rules.length; ++i) {
                String set = this.rules[i];
                File ruleFile = new File(this.rulesDirectory, set);
                if (ruleFile.exists()) {
                    this.getLog().debug((CharSequence)("Add rules file: " + this.rulesDirectory + File.separator + this.rules[i]));
                } else {
                    this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
                    ruleFile = this.locator.getResourceAsFile(set, this.getLocationTemp(set));
                    if (null == ruleFile) {
                        throw new MojoExecutionException("Could not resolve rules file: " + set);
                    }
                }
                macker.addRulesFile(ruleFile);
            }
        }
        catch (ResourceNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (FileResourceCreationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    private Macker createMacker(File outputFile) throws IOException, MojoExecutionException {
        ForkedMacker macker = new ForkedMacker();
        macker.setLog(this.getLog());
        macker.setMaxmem(this.maxmem);
        macker.setPluginClasspathList(this.collectArtifactList());
        macker.setQuiet(this.quiet);
        macker.setVerbose(this.verbose);
        macker.setXmlReportFile(outputFile);
        if (this.maxmsg > 0) {
            macker.setPrintMaxMessages(this.maxmsg);
        }
        if (this.print != null) {
            macker.setPrintThreshold(this.print);
        }
        if (this.anger != null) {
            macker.setAngerThreshold(this.anger);
        }
        return macker;
    }

    private List collectArtifactList() throws MojoExecutionException {
        Artifact myself = (Artifact)this.getProject().getPluginArtifactMap().get("org.codehaus.mojo:macker-maven-plugin");
        try {
            this.resolver.resolve(myself, this.remoteRepositories, this.localRepository);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        ArrayList<Artifact> classpath = new ArrayList<Artifact>();
        classpath.add(myself);
        classpath.addAll(this.pluginClasspathList);
        return classpath;
    }

    public MavenProject getProject() {
        return this.project;
    }

    private List getFilesToProcess() throws IOException {
        ArrayList<File> directories = new ArrayList<File>();
        if (this.classesDirectory != null && this.classesDirectory.isDirectory()) {
            directories.add(this.classesDirectory);
        }
        if (this.includeTests) {
            if (this.testClassesDirectory != null && this.testClassesDirectory.isDirectory()) {
                directories.add(this.testClassesDirectory);
            } else {
                this.getLog().info((CharSequence)("No class files in test directory: " + this.testClassesDirectory));
            }
        }
        String excluding = this.getExcludes();
        this.getLog().debug((CharSequence)("Exclusions: " + excluding));
        String including = this.getIncludes();
        this.getLog().debug((CharSequence)("Inclusions: " + including));
        LinkedList files = new LinkedList();
        Iterator i = directories.iterator();
        while (i.hasNext()) {
            File sourceDirectory = (File)i.next();
            if (!sourceDirectory.isDirectory()) continue;
            List newfiles = FileUtils.getFiles((File)sourceDirectory, (String)including, (String)excluding);
            files.addAll(newfiles);
        }
        return files;
    }

    private String getIncludes() {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        if (this.includes != null) {
            patterns.addAll(Arrays.asList(this.includes));
        }
        if (patterns.isEmpty()) {
            patterns.add("**/*.class");
        }
        return StringUtils.join(patterns.iterator(), (String)",");
    }

    private String getExcludes() {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>(FileUtils.getDefaultExcludesAsList());
        if (this.excludes != null) {
            patterns.addAll(Arrays.asList(this.excludes));
        }
        return StringUtils.join(patterns.iterator(), (String)",");
    }

    void setRules(String[] ruleSets) {
        this.rules = (String[])ruleSets.clone();
    }
}

