/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.macker;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class CommandLineBuilder {
    private static final String LINESEP = System.getProperty("line.separator");
    private final File commandLineFile;
    private final FileWriter commandLineWriter;

    public CommandLineBuilder(String name) throws IOException {
        this.commandLineFile = File.createTempFile(name + ".", ".cmdline");
        this.commandLineFile.deleteOnExit();
        this.commandLineWriter = new FileWriter(this.commandLineFile);
    }

    public void addArg(String arg) throws IOException {
        if (arg == null) {
            throw new IllegalArgumentException("arg is null");
        }
        this.commandLineWriter.write(arg + LINESEP);
    }

    public void addArg(String arg1, String arg2) throws IOException {
        this.addArg(arg1);
        this.addArg(arg2);
    }

    public void saveArgs() throws IOException {
        this.commandLineWriter.flush();
        this.commandLineWriter.close();
    }

    public String getCommandLineFile() throws IOException {
        return this.commandLineFile.getCanonicalFile().getAbsolutePath();
    }

    public void dispose() {
        this.commandLineFile.delete();
    }
}

