/*
 * Decompiled with CFR 0.152.
 */
package com.zuhlke.kbr.complexity.visualization;

import com.zuhlke.kbr.complexity.visualization.DistributionWithRegrerssion;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;

public class Visualization {
    private DistributionWithRegrerssion distribution;
    private ApplicationFrame frame;

    public Visualization(DistributionWithRegrerssion distributionWithRegrerssion) {
        this.distribution = distributionWithRegrerssion;
    }

    public void visualizeModelWithGivenTitle(String string) {
        this.openApplicationFrameShowing(this.nicelyFormatted(this.namedSimpleScatterPlotOf(this.distribution.actualAndRegressionData(), string)));
    }

    private JFreeChart nicelyFormatted(JFreeChart jFreeChart) {
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setDomainAxis((ValueAxis)new LogarithmicAxis("Cyclomatic Complexity"));
        xYPlot.setRangeAxis((ValueAxis)new LogarithmicAxis("Method count"));
        return jFreeChart;
    }

    private void openApplicationFrameShowing(JFreeChart jFreeChart) {
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.frame = new ApplicationFrame("Measure 0.3 \u00a9 2008 Zuhlke Engineering Ltd");
        chartPanel.setMinimumSize(new Dimension(300, 300));
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.frame.setContentPane((Container)chartPanel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private JFreeChart namedSimpleScatterPlotOf(XYSeriesCollection xYSeriesCollection, String string) {
        return ChartFactory.createScatterPlot((String)string, (String)"", (String)"", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
    }

    public boolean isVisible() {
        return this.frame.isShowing();
    }
}

