/*
 * Decompiled with CFR 0.152.
 */
package com.zuhlke.kbr.complexity.visualization;

import com.zuhlke.kbr.complexity.ParetoDistribution;
import java.text.DecimalFormat;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DistributionWithRegrerssion {
    private static final int FIRST_SERIES = 0;
    private ParetoDistribution model;

    public DistributionWithRegrerssion(ParetoDistribution paretoDistribution) {
        this.model = paretoDistribution;
    }

    public void addActualDataTo(XYSeriesCollection xYSeriesCollection) {
        xYSeriesCollection.addSeries(this.model.series());
    }

    public void addRegressionDataTo(XYSeriesCollection xYSeriesCollection) {
        double[] dArray = Regression.getPowerRegression((XYDataset)xYSeriesCollection, (int)0);
        double d = dArray[0];
        double d2 = dArray[1];
        DecimalFormat decimalFormat = new DecimalFormat("###0.0#");
        XYSeries xYSeries = new XYSeries((Comparable)((Object)("regression: |\u03b1| =" + decimalFormat.format(Math.abs(d2)))));
        for (XYDataItem xYDataItem : this.model) {
            double d3 = xYDataItem.getX().doubleValue();
            xYSeries.add(d3, d * Math.pow(d3, d2));
        }
        xYSeriesCollection.addSeries(xYSeries);
    }

    public XYSeriesCollection actualAndRegressionData() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        this.addActualDataTo(xYSeriesCollection);
        this.addRegressionDataTo(xYSeriesCollection);
        return xYSeriesCollection;
    }
}

