/*
 * Decompiled with CFR 0.152.
 */
package com.zuhlke.kbr.complexity.io;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.zuhlke.kbr.complexity.Analyser;
import com.zuhlke.kbr.complexity.ComplexityObservationToDistributionMultiplexor;
import com.zuhlke.kbr.complexity.ParetoDistribution;
import com.zuhlke.kbr.complexity.ZipfDistribution;
import com.zuhlke.kbr.complexity.io.AuditListenerAdaptor;
import com.zuhlke.kbr.complexity.io.ConcreteComplexityObservation;
import com.zuhlke.kbr.complexity.io.DataExportToR;
import com.zuhlke.kbr.complexity.visualization.DistributionWithRegrerssion;
import com.zuhlke.kbr.complexity.visualization.Visualization;
import java.io.IOException;

public class ComplexityListener
extends AuditListenerAdaptor
implements AuditListener {
    private Visualization visualization;
    private ComplexityObservationToDistributionMultiplexor model;
    private Analyser analyzer;
    private boolean writeData = false;
    private String codebaseName;

    public void auditFinished(AuditEvent auditEvent) {
        if (this.writeData) {
            try {
                new DataExportToR(this.model).writeDataFor(this.codebaseName);
            }
            catch (IOException iOException) {
                System.err.println("# could not write data for R");
                System.err.println(iOException);
            }
        }
        this.showChart(System.getProperty("title"));
        this.waitForChartToBeDismissed();
    }

    private void showChart(String string) {
        this.visualization = new Visualization(new DistributionWithRegrerssion(new ParetoDistribution(this.model)));
        this.visualization.visualizeModelWithGivenTitle(string);
    }

    private void waitForChartToBeDismissed() {
        while (this.visualization.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public void auditStarted(AuditEvent auditEvent) {
        this.model = new ZipfDistribution();
        this.analyzer = new Analyser().withListener(this.model);
    }

    public void addError(AuditEvent auditEvent) {
        this.analyzer.noteAnyComplexityReportedIn(ConcreteComplexityObservation.wrapping(auditEvent).message());
    }

    public void setName(String string) {
        this.codebaseName = string;
    }

    public void setWriteRToStdOut(String string) {
        this.writeData = string.equals("y");
    }
}

