/*
 * Decompiled with CFR 0.152.
 */
package com.zuhlke.kbr.complexity;

import com.zuhlke.kbr.complexity.ComplexityObservationToDistributionMultiplexor;
import com.zuhlke.kbr.complexity.LogLogDistribution;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZipfDistribution
extends LogLogDistribution
implements ComplexityObservationToDistributionMultiplexor {
    private static Double ONE = new Double(1.0);
    protected Map<Double, Double> valueToOcurrance = new HashMap<Double, Double>();

    public int populationSize() {
        return this.valueToOcurrance.size();
    }

    public double ocurrancesOf(int n) {
        Double d = new Double(n);
        return this.valueToOcurrance.containsKey(d) ? this.valueToOcurrance.get(d) : 0.0;
    }

    public void noteOcurranceOf(int n) {
        Double d = new Double(n);
        if (this.valueToOcurrance.containsKey(d)) {
            this.valueToOcurrance.put(d, new Double(this.valueToOcurrance.get(d) + 1.0));
        } else {
            this.valueToOcurrance.put(d, ONE);
        }
    }

    public double[][] distribution() {
        double[][] dArray = new double[this.populationSize()][2];
        Iterator<Double> iterator = this.valueToOcurrance.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Double d = iterator.next();
            Double d2 = this.valueToOcurrance.get(d);
            dArray[n++] = new double[]{d, d2};
        }
        return dArray;
    }
}

