/*
 * Decompiled with CFR 0.152.
 */
package com.zuhlke.kbr.complexity;

import com.zuhlke.kbr.complexity.DistributionProvider;
import com.zuhlke.kbr.complexity.LogLogDistribution;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.math.stat.regression.SimpleRegression;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParetoDistribution
extends LogLogDistribution
implements Iterable<XYDataItem> {
    private DistributionProvider zipfModel;

    private Iterator<XYDataItem> dataItems() {
        return this.series().getItems().iterator();
    }

    public ParetoDistribution(DistributionProvider distributionProvider) {
        this.zipfModel = distributionProvider;
    }

    @Override
    public double[][] distribution() {
        double[][] dArray = this.zipfModel.distribution();
        Arrays.sort(dArray, ParetoDistribution.byFirstElementOfSubArrayAscending());
        return ParetoDistribution.accumulate(dArray);
    }

    public static double[][] accumulate(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][2];
        dArray2[dArray2.length - 1][0] = dArray[dArray2.length - 1][0];
        dArray2[dArray2.length - 1][1] = dArray[dArray2.length - 1][1];
        for (int i = dArray2.length - 2; -1 < i; --i) {
            dArray2[i][0] = dArray[i][0];
            dArray2[i][1] = dArray[i][1] + dArray2[i + 1][1];
        }
        return dArray2;
    }

    public static Comparator<double[]> byFirstElementOfSubArrayAscending() {
        return new Comparator<double[]>(){

            @Override
            public int compare(double[] dArray, double[] dArray2) {
                double d = dArray[0];
                double d2 = dArray2[0];
                return d < d2 ? -1 : (d == d2 ? 0 : 1);
            }
        };
    }

    public XYSeries series() {
        return this.labledSeriesForDistribution("actual (cumulative)", this.distribution());
    }

    private XYSeries labledSeriesForDistribution(String string, double[][] dArray) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)string));
        for (int i = 0; i < dArray.length; ++i) {
            xYSeries.add(new XYDataItem(dArray[i][0], dArray[i][1]));
        }
        return xYSeries;
    }

    public SimpleRegression regressionInLinearSpace() {
        SimpleRegression simpleRegression = new SimpleRegression();
        simpleRegression.addData(this.distribution());
        return simpleRegression;
    }

    @Override
    public Iterator<XYDataItem> iterator() {
        return this.dataItems();
    }
}

