/*
 * Decompiled with CFR 0.152.
 */
package com.zuhlke.kbr.complexity;

import com.puppycrawl.tools.checkstyle.Main;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Measure {
    private static void printUsageAndExit() {
        System.out.println("Usage:");
        System.out.println("   $0 [-h | -n | [-t title] -d source_dir]");
        System.out.println();
        System.out.println("    -h");
        System.out.println("        print this message");
        System.out.println("        ");
        System.out.println("    -n");
        System.out.println("        what's new in this release");
        System.out.println();
        System.out.println("    [-t title] -d source_dir");
        System.out.println("        report on the distribution of complexity of the java source code");
        System.out.println("        (files matching *.java) found under the given directory. Files matching the");
        System.out.println("        pattern in filestoIgnore.xml are not examined. If -t is given, use the argument");
        System.out.println("        as the title of the graph.");
        System.exit(0);
    }

    private static void printNewsAndExit() {
        System.out.println("News");
        System.out.println("   In measure 0.3 the actual cumulative complexity data and the Pareto distribution derived");
        System.out.println("   from it are shown on a chart.");
        System.out.println();
        System.out.println("   Measure now runs as a Checkstyle listener, so there is no intermediate data file.");
        System.out.println();
        System.out.println("   A .tfl file is created, suitable for loading into R. This has to be enabled in the cc.xml");
        System.exit(0);
    }

    private static void runOn(String string, String string2) {
        System.out.println("# collecting data from " + string2 + "...");
        if (string == null) {
            string = string2;
        }
        System.setProperty("title", string);
        Main.main((String[])new String[]{"-c", "cc.xml", "-r", string2});
    }

    public static void main(String[] stringArray) throws ParseException {
        System.out.println("Measure 0.3, Copyright (C) 2008 Zuhlke Engineering Ltd.");
        System.out.println("Measure comes with ABSOLUTELY NO WARRANTY.");
        if (stringArray.length == 0) {
            Measure.printUsageAndExit();
        }
        Options options = new Options();
        options.addOption("h", "help", false, "print this message");
        options.addOption("n", "news", false, "what's new in this release");
        options.addOption("t", "title", true, "title of the graph");
        options.addOption("d", "source_dir", true, "java source code directory");
        CommandLine commandLine = new BasicParser().parse(options, stringArray);
        if (commandLine.hasOption('h')) {
            Measure.printUsageAndExit();
        }
        if (commandLine.hasOption('n')) {
            Measure.printNewsAndExit();
        }
        String string = null;
        if (commandLine.hasOption('t')) {
            string = commandLine.getOptionValue('t');
        }
        if (commandLine.hasOption('d')) {
            String string2 = commandLine.getOptionValue('d');
            Measure.runOn(string, string2);
        }
        Measure.printUsageAndExit();
    }
}

