/*
 * Decompiled with CFR 0.152.
 */
package com.zuhlke.kbr.complexity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math.stat.regression.SimpleRegression;

public class Analyser {
    private ComplexityObserver observer;
    private Pattern complexityPattern = Pattern.compile(".*Complexity is (\\d+).*");
    private Matcher matcher;

    public Pattern complexityPattern() {
        return this.complexityPattern;
    }

    public int complexityFromMostRecentMatch() {
        return Integer.parseInt(this.matcher.group(1));
    }

    public Analyser withListener(ComplexityObserver complexityObserver) {
        this.observer = complexityObserver;
        return this;
    }

    public void noteAnyComplexityReportedIn(String string) {
        if (this.complexityInformationIn(string)) {
            this.observer.noteOcurranceOf(this.complexityFromMostRecentMatch());
        }
    }

    public boolean complexityInformationIn(String string) {
        this.matcher = this.complexityPattern().matcher(string);
        return this.matcher.matches();
    }

    public static interface ComplexityObserver {
        public void noteOcurranceOf(int var1);

        public double[][] logLogDistribution();

        public SimpleRegression regressionInLogLogSpace();
    }
}

