package at.kugel.tool.buildtray.util;

import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public class HttpHeaders {

   public static void setInto(URLConnection con, List<Map.Entry<String, String>> headers) {
      if (headers != null) {
         for (Map.Entry<String, String> elem : headers) {
            setInto(con, elem);
         }
         headers.clear();
      }
   }

   private static void setInto(URLConnection con, Map.Entry<String, String> header) {
      if (isFirstHeader(header)) {
         return;
      }
      con.setRequestProperty(header.getKey(), header.getValue());
   }

   private static boolean isFirstHeader(Map.Entry<String, String> header) {
      return header.getKey().equals("");
   }

   public static void readFrom(URLConnection con, List<Map.Entry<String, String>> headers) {
      if (headers != null) {
         headers.clear();

         int i = 0;
         while (con.getHeaderField(i) != null) {
            readFrom(con, i, headers);
            i++;
         }
      }
   }

   private static void readFrom(URLConnection con, int index, List<Map.Entry<String, String>> headers) {
      String key = con.getHeaderFieldKey(index);
      if (key == null) {
         // first header...
         key = "";
      }
      String val = con.getHeaderField(index);
      headers.add(new HttpHeaderEntry(key, val));
   }

}
