package at.kugel.tool.buildtray.util;

import java.util.Map;

public class HttpHeaderEntry implements Map.Entry<String, String> {

   private final String key;
   private String value;

   public HttpHeaderEntry(String headerName, String headerValue) {
      key = headerName;
      value = headerValue;
   }

   @Override
   public String getKey() {
      return key;
   }

   @Override
   public String getValue() {
      return value;
   }

   @Override
   public String setValue(String newValue) {
      String oldValue = value;
      value = newValue;
      return oldValue;
   }

}