package at.kugel.tool.buildtray.util;

import java.awt.Desktop;
import java.awt.Desktop.Action;
import java.io.IOException;

/**
 * Check if the requested Java 6 Desktop operation is available and execute.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public abstract class DesktopOperation {

   private final Action desktopAction;

   public DesktopOperation(Action desktopAction) {
      this.desktopAction = desktopAction;
   }

   public abstract void runWithDesktop(Desktop deskTop) throws IOException;

   public void run() throws IOException {
      if (Desktop.isDesktopSupported()) {
         Desktop deskTop = Desktop.getDesktop();
         if (deskTop.isSupported(desktopAction)) {
            runWithDesktop(deskTop);
            return;
         }
      }
      throw new UnsupportedOperationException("Java 6 Desktop." + desktopAction + " is not supported");
   }

}
