package at.kugel.tool.buildtray.status;

/**
 * The build status.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public enum Status {
   OK, BUSY, FAILED, UNKNOWN;

   public boolean isWorseThan(Status other) {
      return ordinal() > other.ordinal();
   }

   public boolean sameOrWorseThan(Status other) {
      return isSame(other) || isWorseThan(other);
   }

   private boolean isSame(Status other) {
      return ordinal() == other.ordinal();
   }
}
