package at.kugel.tool.buildtray.config;

import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.regex.Pattern;

/**
 * Configuration for the tray.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public interface Config {

   File getConfigFileLocation();

   long getPollingMs();

   URL getServerlUrl();

   URL getServerDisplayUrl();

   CheckBusy getCheckBusy();

   DateFormat getDatePattern();

   long getSplashWaitMs();

   Pattern getBusyPattern();

   String getSuccessValue();

   String getFailedValue();

   Pattern getStatusPattern();

   int getStatusPatternNameGroup();

   int getStatusPatternStatusGroup();

   int getStatusPatternDateGroup();

   boolean useProxy();

   String getProxyHost();

   int getProxyPort();

   boolean useAuth();

   String getServerUsername();

   String getServerPassword();

   boolean useTrustStore();

   String getTrustStore();

   String getTrustStorePassword();

}
