package at.kugel.tool.buildtray.config;

/**
 * Kinds of how to check for busy.
 * 
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public enum CheckBusy {

   CHECK("true"), IGNORE("false"), // backward compatible with 1.3 boolean config names 
   SKIP("skip");

   private final String configValue;

   CheckBusy(String configValue) {
      this.configValue = configValue;
   }

   public static CheckBusy fromConfig(String value) {
      if (value == null) {
         // default value of boolean 
         return IGNORE;
      }

      for (CheckBusy cb : values()) {
         if (cb.name().equalsIgnoreCase(value) || cb.configValue.equalsIgnoreCase(value)) {
            return cb;
         }
      }

      throw new EnumConstantNotPresentException(CheckBusy.class, value);
   }
}
