package at.kugel.tool.buildtray.action;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/**
 * Collection of SSL helper methods to start SSL.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public class SSLHelper {

   public static void disableHTTPSChecks() {
      disableHTTPSCertificateValidation();
      disableHTTPSHostnameVerification();
   }

   /**
    * Disabling Certificate Validation in an HTTPS Connection. By default, accessing an HTTPS URL using the URL class results in an
    * exception if the server's certificate chain cannot be validated has not previously been installed in the truststore. If you want to
    * disable the validation of certificates for testing purposes, you need to override the default trust manager with one that trusts all
    * certificates.
    */
   public static void disableHTTPSCertificateValidation() {

      // no key manager - we do not present any keys to the server...
      final KeyManager[] km = null;

      // Create a trust manager that does not validate certificate chains
      final TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {
         @Override
         public X509Certificate[] getAcceptedIssuers() {
            return null;
         }

         @Override
         public void checkClientTrusted(X509Certificate[] certs, String authType) {
            // allow all
         }

         @Override
         public void checkServerTrusted(X509Certificate[] certs, String authType) {
            // allow all
         }
      } };

      // Install the all-trusting trust manager
      try {
         final SSLContext sc = SSLContext.getInstance("SSL");
         sc.init(km, trustAllCerts, new SecureRandom());
         HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
      } catch (KeyManagementException ex) {
         throw new UnsupportedOperationException("could not set default SSL socket factory", ex);
      } catch (NoSuchAlgorithmException ex) {
         throw new UnsupportedOperationException("could not set default SSL socket factory", ex);
      }

      // Now you can access an https URL without having the certificate in the truststore
   }

   public static void disableHTTPSHostnameVerification() {
      final HostnameVerifier hv = new HostnameVerifier() {
         @Override
         public boolean verify(String urlHostname, SSLSession session) {
            return true;
         }
      };
      HttpsURLConnection.setDefaultHostnameVerifier(hv);
   }

}
