package at.kugel.tool.buildtray.action;

import java.util.regex.Matcher;

import at.kugel.tool.buildtray.config.CheckBusy;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.Status;

/**
 * Parse content if it matches the busy criteria from the configuration.
 * 
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
class RegexBusyParser implements RegexParser {

   private final Matcher busyPatternMatcher;
   private final boolean updateStatus;

   public RegexBusyParser(Config config, String content) {
      if (config.getCheckBusy() != CheckBusy.IGNORE) {
         busyPatternMatcher = config.getBusyPattern().matcher(content);
         updateStatus = config.getCheckBusy() == CheckBusy.CHECK;
      } else {
         busyPatternMatcher = null;
         updateStatus = false;
      }
   }

   public boolean isBusy() {
      return busyPatternMatcher != null && busyPatternMatcher.find();
   }

   public boolean isUpdateStatus() {
      return updateStatus;
   }

   @Override
   public Status getStatus() {
      return Status.BUSY;
   }

   @Override
   public String getProjectName() {
      return busyPatternMatcher.group(1);
   }

   @Override
   public String getBuildDate() {
      return null;
   }

   public String annotate() {
      return busyPatternMatcher.replaceFirst("___BUSY[[[$0]]]BUSY___($1)___");
   }

}