package at.kugel.tool.buildtray.action;

import java.io.IOException;
import java.text.ParseException;

import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;
import at.kugel.tool.buildtray.status.Status;

/**
 * Refresh the status and set it into the tray.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
class RefreshCommand extends ActionCommand {

   public RefreshCommand(Config config, SetStatusAble statusDisplay) {
      super(config, statusDisplay);
   }

   @Override
   protected void workTemplate() throws IOException, ParseException {
      updateBuildResult();
   }

   private void updateBuildResult() throws IOException, ParseException {
      String content = downloadBuildStatus();

      if (handleBusyProject(content)) {
         return;
      }

      handleRegularProjects(content);
   }

   private String downloadBuildStatus() throws IOException {
      return new URLReader(config).readPage();
   }

   private boolean handleBusyProject(String content) {
      RegexBusyParser busyParser = new RegexBusyParser(config, content);
      if (busyParser.isBusy()) {
         if (busyParser.isUpdateStatus()) {
            updateStatusFrom(busyParser);
         }
         return true;
      }
      return false;
   }

   private void updateStatusFrom(RegexParser parser) {
      Status status = parser.getStatus();
      String projectName = parser.getProjectName();
      String buildDate = parser.getBuildDate();
      statusDisplay.setStatus(status, projectName, buildDate);
   }

   private void handleRegularProjects(String content) throws ParseException {
      RegexStatusParser statusParser = new RegexStatusParser(config, content);
      statusParser.parse();
      updateStatusFrom(statusParser);
   }

}
