package at.kugel.tool.buildtray.action;

import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Create a popup menu for each item in the actions.
 *
 * @see Actions
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public class PopupBuilder {

   private final PopupMenu popup = new PopupMenu();

   private final Actions actions;

   public PopupBuilder(Actions actions) {
      this.actions = actions;
   }

   public PopupMenu create() {
      addBrowse();
      addRefresh();
      addDisplay();
      addSeparator();
      addConfig();
      addSeparator();
      addExit();

      return popup;
   }

   private void addBrowse() {
      addEntry("open build server in web browser", new ActionListener() {
         @Override
         public void actionPerformed(ActionEvent e) {
            actions.openBrowser();
         }
      });
   }

   private void addEntry(String label, ActionListener command) {
      MenuItem item = new MenuItem(label);
      item.addActionListener(command);
      popup.add(item);
   }

   private void addRefresh() {
      addEntry("refresh build status now", new ActionListener() {
         @Override
         public void actionPerformed(ActionEvent e) {
            actions.refresh();
         }
      });
   }

   private void addDisplay() {
      addEntry("display annotated server response", new ActionListener() {
         @Override
         public void actionPerformed(ActionEvent e) {
            actions.showServerResponse();
         }
      });
   }

   private void addSeparator() {
      popup.addSeparator();
   }

   private void addConfig() {
      addEntry("edit current configuration and reload", new ActionListener() {
         @Override
         public void actionPerformed(ActionEvent e) {
            actions.editConfiguration();
         }
      });
   }

   private void addExit() {
      addEntry("exit", new ActionListener() {
         @Override
         public void actionPerformed(ActionEvent e) {
            actions.exit();
         }
      });
   }

}
