package at.kugel.tool.buildtray.action;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;
import at.kugel.tool.buildtray.util.DesktopOperation;

/**
 * Open the browser with the main page of the build server. Invoke Desktip BROWSE.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
class OpenBrowserCommand extends ActionCommand {

   public OpenBrowserCommand(Config config, SetStatusAble statusDisplay) {
      super(config, statusDisplay);
   }

   @Override
   protected void workTemplate() throws IOException {
      openDesktopBrowser();
   }

   private void openDesktopBrowser() throws IOException {
      new DesktopOperation(Desktop.Action.BROWSE) {
         @Override
         public void runWithDesktop(Desktop deskTop) throws IOException {
            deskTop.browse(createDisplayUri());
         }
      }.run();
   }

   private URI createDisplayUri() throws IOException {
      try {
         return determineDisplayUrl().toURI();
      } catch (URISyntaxException e) {
         throw new IOException(e);
      }
   }

   private URL determineDisplayUrl() {
      URL url = config.getServerDisplayUrl();
      if (url == null) {
         url = config.getServerlUrl();
      }
      return url;
   }

}
