package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;

/**
 * Implementation of tray actions using regular expressions from the config.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public class HtmlRegularExpressionActions implements Actions {

   private final Config config;
   private SetStatusAble statusDisplay;

   public HtmlRegularExpressionActions(Config config) {
      this.config = config;
   }

   @Override
   public void setStatusDisplay(SetStatusAble statusAble) {
      statusDisplay = statusAble;
   }

   @Override
   public void openBrowser() {
      new OpenBrowserCommand(config, statusDisplay).execute();
   }

   @Override
   public void refresh() {
      new RefreshCommand(config, statusDisplay).execute();
   }

   @Override
   public void showServerResponse() {
      new ShowServerResponseCommand(config, statusDisplay).execute();
   }

   @Override
   public void editConfiguration() {
      new EditConfigurationCommand(config, statusDisplay).execute();
   }

   @Override
   public void exit() {
      System.exit(0);
   }

}
