package at.kugel.tool.buildtray.action;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;
import at.kugel.tool.buildtray.util.DesktopOperation;

/**
 * Open the configuration for editing.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
class EditConfigurationCommand extends ActionCommand {

   public EditConfigurationCommand(Config config, SetStatusAble statusDisplay) {
      super(config, statusDisplay);
   }

   @Override
   protected void workTemplate() throws IOException {
      openConfigFile();
   }

   private void openConfigFile() throws IOException {
      try {
         openConfigInEditor();
      } catch (IOException e) {
         // failes if *.properties is not registered, desperate, so try notepad ... DIRTY
         openConfigInNotepad();
      }
   }

   private void openConfigInEditor() throws IOException {
      new DesktopOperation(Desktop.Action.EDIT) {
         @Override
         public void runWithDesktop(Desktop deskTop) throws IOException {
            deskTop.edit(configurationFile());
         }
      }.run();
   }

   private File configurationFile() {
      return config.getConfigFileLocation();
   }

   private void openConfigInNotepad() throws IOException {
      new ProcessBuilder("notepad.exe", configurationFile().toString()).start();
   }

}
