package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;

/**
 * Commands to execute in the action.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
abstract class ActionCommand {

   protected final Config config;
   protected final SetStatusAble statusDisplay;

   public ActionCommand(Config config, SetStatusAble statusDisplay) {
      this.config = config;
      this.statusDisplay = statusDisplay;
   }

   public void execute() {
      try {

         workTemplate();

      } catch (Exception e) {
         handleError(e);
      }
   }

   protected abstract void workTemplate() throws Exception;

   private void handleError(Exception ex) {
      statusDisplay.setError(ex);
   }

}