package at.kugel.tool.buildtray;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;

import at.kugel.tool.buildtray.action.Actions;
import at.kugel.tool.buildtray.action.PopupBuilder;
import at.kugel.tool.buildtray.status.Status;
import at.kugel.tool.buildtray.status.TrayIconStatus;

/**
 * Setup the tray with popup menu and image icon list.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public class TrayIconFactory {

   private final Status initialStatus = Status.BUSY;
   private final String initialTip = "Build Status Tray";

   private EnumMap<Status, Image> images;
   private TrayIcon trayIcon;

   public TrayIconFactory() {
      loadImages();
      createTrayIcon();
   }

   private void loadImages() {
      images = new EnumMap<Status, Image>(Status.class);
      images.put(Status.OK, loadImage("res/build_green.gif"));
      images.put(Status.BUSY, loadImage("res/build_white.gif"));
      images.put(Status.FAILED, loadImage("res/build_red.gif"));
   }

   private Image loadImage(String fileName) {
      return Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(fileName));
   }

   private void createTrayIcon() {
      Image image = images.get(initialStatus);
      trayIcon = new TrayIcon(image, initialTip);
   }

   public TrayIconStatus create(Actions actions) throws AWTException {
      setRightClickPopup(actions);
      setLeftClickDefault(actions);
      addToSystemTray();

      return new TrayIconStatus(trayIcon, images);
   }

   private void setRightClickPopup(Actions actions) {
      PopupMenu popup = new PopupBuilder(actions).create();
      trayIcon.setPopupMenu(popup);
   }

   private void setLeftClickDefault(final Actions actions) {
      trayIcon.addActionListener(new ActionListener() {
         @Override
         public void actionPerformed(ActionEvent e) {
            actions.openBrowser();
         }
      });
   }

   private void addToSystemTray() throws AWTException {
      SystemTray systemTray = SystemTray.getSystemTray();
      systemTray.add(trayIcon);
   }

}
