package at.kugel.tool.buildtray;

import at.kugel.tool.buildtray.action.Actions;
import at.kugel.tool.buildtray.action.HtmlRegularExpressionActions;
import at.kugel.tool.buildtray.action.URLReader;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.config.ReloadingConfig;
import at.kugel.tool.buildtray.status.ConsoleStatus;

/**
 * Loads the build server url with all settings for debug purposes.
 *
 * @author <a href="http://www.code-cop.org/">Peter Kofler</a>
 */
public final class CheckConfig {

   public static void main(String[] args) {

      handleEmptyArguments(args);

      String configFileName = args[0];
      Config conf = new ReloadingConfig(configFileName);

      tryServerAccess(conf);

      checkBuildStatus(conf);

   }

   private static void handleEmptyArguments(String[] args) {
      if (args.length != 1) {
         System.out.println("Usage: java -jar BuildServerSystemTray.jar <path to config file, e.g. \"config/Hudson-1.2.properties\">");
         System.exit(2);
      }
   }

   private static void tryServerAccess(Config conf) {
      System.out.println("checking server access...");
      try {
         String content = new URLReader(conf).readPage();
         System.out.println(content);
      } catch (Exception ex) {
         ex.printStackTrace(System.err);
      }
   }

   private static void checkBuildStatus(Config conf) {
      System.out.println("checking build status...");
      Actions actions = new HtmlRegularExpressionActions(conf);
      actions.setStatusDisplay(new ConsoleStatus());
      actions.refresh();
   }

}
