/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.status;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class TrayPopup
extends Frame {
    private static final Color FG_COLOR = Color.BLACK;
    private static final Color BG_COLOR = new Color(255, 255, 220);
    private static final String FONT_NAME = "Arial";
    private final Label title = new Label();
    private final TextArea message = new TextArea("", 1, 1, 3);

    public TrayPopup() {
        this.setWindowProperties();
        this.setComponentProperties(this);
        this.setLayout(new BorderLayout());
        this.addTitleLabel();
        this.addMessageArea();
    }

    private void setWindowProperties() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setFocusableWindowState(false);
    }

    private void addTitleLabel() {
        this.setComponentProperties(this.title);
        this.title.setAlignment(1);
        this.title.setFont(new Font(FONT_NAME, 1, 12));
        this.add((Component)this.title, "North");
    }

    private void addMessageArea() {
        this.setComponentProperties(this.message);
        this.message.setEditable(false);
        this.add((Component)this.message, "Center");
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void setComponentProperties(Component component) {
        component.setFocusable(false);
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TrayPopup.this.close();
            }
        });
        component.setBackground(BG_COLOR);
        component.setForeground(FG_COLOR);
        component.setFont(new Font(FONT_NAME, 0, 10));
    }

    void displayMessage(String string, String string2) {
        this.updateTitle(string);
        this.updateTextArea(string2);
        this.pack();
        this.center();
        this.setVisible(true);
    }

    private void updateTitle(String string) {
        this.title.setText(string);
    }

    private void updateTextArea(String string) {
        String[] stringArray = string.split("\n");
        this.setTextAreaRows(stringArray);
        this.setTextAreaColumns(stringArray);
        this.message.setText(string);
    }

    private void setTextAreaRows(String[] stringArray) {
        this.message.setRows(stringArray.length);
    }

    private void setTextAreaColumns(String[] stringArray) {
        this.message.setColumns(1);
        for (String string : stringArray) {
            if (string.length() <= this.message.getColumns()) continue;
            this.message.setColumns(string.length());
        }
    }

    private void center() {
        int n = this.calcMostRightPosition();
        int n2 = this.calcMostDownPosition();
        this.setLocation(n, n2);
    }

    private int calcMostRightPosition() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        return dimension2.width - dimension.width;
    }

    private int calcMostDownPosition() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        int n = SystemTray.getSystemTray().getTrayIconSize().height;
        return dimension2.height - dimension.height - n - 4;
    }
}

