/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.status;

import at.kugel.tool.buildtray.status.SetStatusAble;
import at.kugel.tool.buildtray.status.Status;
import at.kugel.tool.buildtray.status.TrayPopup;
import java.awt.Image;
import java.awt.TrayIcon;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumMap;

public class TrayIconStatus
implements SetStatusAble {
    private final EnumMap<Status, Image> images;
    private final TrayIcon trayIcon;
    private Status previousStatus;
    private String previousProject;
    private Status currentStatus = Status.BUSY;
    private String currentProject;
    private String buildDate;

    public TrayIconStatus(TrayIcon trayIcon, EnumMap<Status, Image> enumMap) {
        this.trayIcon = trayIcon;
        this.images = enumMap;
    }

    @Override
    public void setStatus(Status status, String string, String string2) {
        this.savePreviousStatus();
        this.currentStatus = status;
        this.currentProject = string;
        this.buildDate = string2;
        this.updateImage();
        this.updateBalloon();
    }

    private void savePreviousStatus() {
        this.previousStatus = this.currentStatus;
        this.previousProject = this.currentProject;
    }

    private void updateImage() {
        this.trayIcon.setImage(this.images.get((Object)this.currentStatus));
    }

    private void updateBalloon() {
        switch (this.currentStatus) {
            case OK: {
                this.updateBalloonOk();
                break;
            }
            case FAILED: {
                this.updateBalloonFailed();
                break;
            }
            case BUSY: {
                this.updateBalloonBusy();
                break;
            }
            default: {
                throw new IllegalArgumentException("impossible unknown status value " + (Object)((Object)this.currentStatus));
            }
        }
    }

    private void updateBalloonOk() {
        String string = "all are " + (Object)((Object)this.currentStatus) + ' ' + this.buildDate;
        this.trayIcon.setToolTip(string);
    }

    private void updateBalloonFailed() {
        String string = this.currentProject + " is " + (Object)((Object)this.currentStatus) + ' ' + this.buildDate;
        this.trayIcon.setToolTip(string);
        if (this.sameProjectChangedToFailed()) {
            this.displayMessage("Build Failed", string, TrayIcon.MessageType.NONE);
        }
    }

    private boolean sameProjectChangedToFailed() {
        return this.currentStatus.isWorseThan(this.previousStatus) && this.currentProject.equals(this.previousProject);
    }

    private void updateBalloonBusy() {
        String string = this.currentProject + " is " + (Object)((Object)this.currentStatus);
        this.trayIcon.setToolTip(string);
        if (this.workingOnDifferentProject()) {
            this.displayMessage("New Build", "Finished " + this.previousProject + "\nBuilding " + this.currentProject, TrayIcon.MessageType.NONE);
        }
    }

    private boolean workingOnDifferentProject() {
        return this.previousProject != null && !this.currentProject.equals(this.previousProject);
    }

    @Override
    public void setError(Exception exception) {
        String string = this.printTrace(exception);
        this.displayMessage("Error " + exception.getMessage(), string, TrayIcon.MessageType.ERROR);
    }

    private String printTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().replaceAll("\\s+", " ");
    }

    private void displayMessage(String string, String string2, TrayIcon.MessageType messageType) {
        if ("5.1".equals(System.getProperty("os.version"))) {
            new TrayPopup().displayMessage(string, string2);
        } else {
            this.trayIcon.displayMessage(string, string2, messageType);
        }
    }
}

