/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.config;

import at.kugel.tool.buildtray.config.CheckBusy;
import at.kugel.tool.buildtray.config.Config;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.regex.Pattern;

public class ReloadingConfig
implements Config {
    private final File path;
    private long lastLoaded;
    private Properties props;

    public ReloadingConfig(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path is null");
        }
        this.path = new File(string);
    }

    @Override
    public File getConfigFileLocation() {
        return this.path;
    }

    private void checkForUpdate() {
        long l = this.configLastModified();
        if (this.lastLoaded < l) {
            this.reloadPropertiesHandleErrors();
            this.lastLoaded = l;
        }
    }

    private long configLastModified() {
        return this.path.lastModified();
    }

    private void reloadPropertiesHandleErrors() {
        try {
            this.reloadProperties();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadProperties() throws IOException {
        this.props = new Properties();
        FileReader fileReader = new FileReader(this.path);
        try {
            this.props.load(fileReader);
        }
        finally {
            ((Reader)fileReader).close();
        }
    }

    @Override
    public long getPollingMs() {
        return this.getInteger("polling.ms");
    }

    private int getInteger(String string) {
        return Integer.parseInt(this.getValue(string));
    }

    private String getValue(String string) {
        this.checkForUpdate();
        return this.props.getProperty(string);
    }

    private URL getUrl(String string) {
        try {
            String string2 = this.getValue(string);
            if (string2 != null && !string2.equals("")) {
                return new URL(string2);
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("broken URL in config", malformedURLException);
        }
    }

    @Override
    public URL getServerlUrl() {
        return this.getUrl("server.url");
    }

    @Override
    public URL getServerDisplayUrl() {
        return this.getUrl("server.display");
    }

    @Override
    public CheckBusy getCheckBusy() {
        return CheckBusy.fromConfig(this.getValue("busy.check"));
    }

    private boolean getBoolean(String string) {
        return Boolean.valueOf(this.getValue(string));
    }

    @Override
    public DateFormat getDatePattern() {
        return new SimpleDateFormat(this.getValue("status.date.format"));
    }

    @Override
    public long getSplashWaitMs() {
        return this.getInteger("splash.wait.ms");
    }

    @Override
    public Pattern getBusyPattern() {
        String string = this.getValue("busy.pattern");
        return Pattern.compile(string);
    }

    @Override
    public String getSuccessValue() {
        return this.getValue("value.success");
    }

    @Override
    public String getFailedValue() {
        return this.getValue("value.failed");
    }

    @Override
    public Pattern getStatusPattern() {
        String string = this.getValue("status.pattern");
        return Pattern.compile(string, 32);
    }

    @Override
    public int getStatusPatternNameGroup() {
        return this.getInteger("status.name.group");
    }

    @Override
    public int getStatusPatternStatusGroup() {
        return this.getInteger("status.value.group");
    }

    @Override
    public int getStatusPatternDateGroup() {
        return this.getInteger("status.date.group");
    }

    @Override
    public String getProxyHost() {
        return this.getValue("proxy.host");
    }

    @Override
    public int getProxyPort() {
        return this.getInteger("proxy.port");
    }

    @Override
    public boolean useProxy() {
        return this.getBoolean("proxy.set");
    }

    @Override
    public boolean useAuth() {
        return this.getBoolean("server.basic.auth");
    }

    @Override
    public String getServerUsername() {
        return this.getValue("server.username");
    }

    @Override
    public String getServerPassword() {
        return this.getValue("server.password");
    }

    @Override
    public String getTrustStore() {
        return this.getValue("server.trust.store.location");
    }

    @Override
    public String getTrustStorePassword() {
        return this.getValue("server.trust.store.password");
    }

    @Override
    public boolean useTrustStore() {
        return this.getBoolean("server.trust.store");
    }
}

