/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.action.SSLHelper;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.util.Base64;
import at.kugel.tool.buildtray.util.HttpHeaderEntry;
import at.kugel.tool.buildtray.util.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class URLReader {
    private final Config config;
    private final List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();

    public URLReader(Config config) {
        this.config = config;
        this.setProxySettings();
        this.setSSLSettings();
    }

    private void setProxySettings() {
        if (this.config.useProxy()) {
            this.setProxy();
        } else {
            this.setNoProxy();
        }
    }

    private void setProxy() {
        System.setProperty("proxySet", Boolean.TRUE.toString());
        System.setProperty("proxyHost", this.config.getProxyHost());
        System.setProperty("proxyPort", Integer.toString(this.config.getProxyPort()));
    }

    private void setNoProxy() {
        System.setProperty("proxySet", Boolean.FALSE.toString());
        System.getProperties().remove("proxyHost");
        System.getProperties().remove("proxyPort");
    }

    private void setSSLSettings() {
        if (this.config.getServerlUrl().getProtocol().equals("https")) {
            if (this.config.useTrustStore()) {
                this.setTrustStore();
            } else {
                this.disableHttpsStores();
            }
        }
    }

    private void setTrustStore() {
        System.setProperty("javax.net.ssl.trustStore", this.config.getTrustStore());
        System.setProperty("javax.net.ssl.trustStorePassword", this.config.getTrustStorePassword());
    }

    private void disableHttpsStores() {
        System.getProperties().remove("javax.net.ssl.trustStore");
        System.getProperties().remove("javax.net.ssl.trustStorePassword");
        SSLHelper.disableHTTPSChecks();
    }

    public String readPage() throws IOException {
        this.setBasicAuth();
        return this.readNet();
    }

    private void setBasicAuth() throws UnsupportedEncodingException {
        if (this.config.useAuth()) {
            String string = this.config.getServerUsername() + ':' + this.config.getServerPassword();
            String string2 = Base64.encode(string.getBytes(), "8859_1");
            this.headers.add(new HttpHeaderEntry("Authorization", "Basic " + string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readNet() throws IOException {
        URLConnection uRLConnection = this.openConnection();
        int n = uRLConnection.getContentLength();
        boolean bl = true;
        if (n < 0) {
            bl = false;
            n = 262144;
        }
        byte[] byArray = new byte[n];
        InputStream inputStream = null;
        try {
            String string;
            int n2;
            inputStream = uRLConnection.getInputStream();
            int n3 = 1;
            for (n2 = 0; n2 < n && n3 > 0; n2 += n3) {
                n3 = inputStream.read(byArray, n2, n - n2);
            }
            if (bl && n2 < n) {
                throw new IOException("short file: length=" + n2 + " != content-length=" + n);
            }
            if (!bl && n2 == n) {
                throw new IOException("possibly long file: length=" + n2 + " != content-length=unknown");
            }
            if (!bl) {
                ++n2;
            }
            if ((string = uRLConnection.getContentEncoding()) == null) {
                String string2 = new String(byArray, 0, n2);
                return string2;
            }
            String string3 = new String(byArray, 0, n2, string);
            return string3;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private URLConnection openConnection() throws IOException {
        URL uRL = this.config.getServerlUrl();
        URLConnection uRLConnection = uRL.openConnection();
        HttpHeaders.setInto(uRLConnection, this.headers);
        uRLConnection.connect();
        HttpHeaders.readFrom(uRLConnection, this.headers);
        return uRLConnection;
    }
}

