/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.action.ActionCommand;
import at.kugel.tool.buildtray.action.RegexBusyParser;
import at.kugel.tool.buildtray.action.RegexStatusParser;
import at.kugel.tool.buildtray.action.URLReader;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;
import at.kugel.tool.buildtray.util.DesktopOperation;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

class ShowServerResponseCommand
extends ActionCommand {
    public ShowServerResponseCommand(Config config, SetStatusAble setStatusAble) {
        super(config, setStatusAble);
    }

    @Override
    protected void workTemplate() throws IOException, TransformerException {
        this.showServerResponse();
    }

    private void showServerResponse() throws IOException, TransformerException {
        String string = this.downloadBuildStatus();
        String string2 = this.format(string);
        String string3 = this.annotate(string2);
        File file = this.saveToFile(string3);
        this.openDesktopEditor(file);
    }

    private String downloadBuildStatus() throws IOException {
        return new URLReader(this.config).readPage();
    }

    private String format(String string) throws TransformerException {
        if (this.isXml(string)) {
            return this.formatXml(string);
        }
        return string;
    }

    private boolean isXml(String string) {
        return string.startsWith("<?xml");
    }

    private String formatXml(String string) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamSource streamSource = new StreamSource(new StringReader(string));
        StreamResult streamResult = new StreamResult(new StringWriter());
        transformer.transform(streamSource, streamResult);
        return streamResult.getWriter().toString();
    }

    private String annotate(String string) {
        RegexBusyParser regexBusyParser = new RegexBusyParser(this.config, string);
        if (regexBusyParser.isBusy()) {
            return regexBusyParser.annotate();
        }
        RegexStatusParser regexStatusParser = new RegexStatusParser(this.config, string);
        return regexStatusParser.annotate();
    }

    private File saveToFile(String string) throws IOException {
        File file = this.createTempFile();
        this.save(string, file);
        return file;
    }

    private File createTempFile() throws IOException {
        File file = File.createTempFile("build-server-tray-log-", ".txt");
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String string, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ((OutputStream)fileOutputStream).write(string.getBytes());
            fileOutputStream.flush();
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    private void openDesktopEditor(final File file) throws IOException {
        new DesktopOperation(Desktop.Action.EDIT){

            @Override
            public void runWithDesktop(Desktop desktop) throws IOException {
                desktop.edit(file);
            }
        }.run();
    }
}

