/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.action.RegexParser;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.Status;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;

class RegexStatusParser
implements RegexParser {
    private final Config config;
    private final DateFormat dateFormat;
    private final Matcher statusPatternMatcher;
    private String lastName;
    private Status lastStatus = Status.OK;
    private Date lastDate = new Date(0L);

    public RegexStatusParser(Config config, String string) {
        this.config = config;
        this.dateFormat = config.getDatePattern();
        this.statusPatternMatcher = config.getStatusPattern().matcher(string);
    }

    public void parse() throws ParseException {
        while (this.hasProject()) {
            this.processProject();
        }
    }

    private boolean hasProject() {
        return this.statusPatternMatcher.find();
    }

    private void processProject() throws ParseException {
        String string = this.parseProjectName();
        Status status = this.parseStatus();
        if (status == Status.UNKNOWN) {
            return;
        }
        Date date = this.parseBuildDate();
        this.updateLatestFailedBuild(string, status, date);
    }

    private String parseProjectName() {
        return this.statusPatternMatcher.group(this.config.getStatusPatternNameGroup());
    }

    private Status parseStatus() {
        String string = this.statusPatternMatcher.group(this.config.getStatusPatternStatusGroup());
        if (string.matches(this.config.getSuccessValue())) {
            return Status.OK;
        }
        if (string.matches(this.config.getFailedValue())) {
            return Status.FAILED;
        }
        return Status.UNKNOWN;
    }

    private Date parseBuildDate() throws ParseException {
        return this.dateFormat.parse(this.statusPatternMatcher.group(this.config.getStatusPatternDateGroup()));
    }

    private void updateLatestFailedBuild(String string, Status status, Date date) {
        if (date.after(this.lastDate) && status.sameOrWorseThan(this.lastStatus)) {
            this.lastName = string;
            this.lastStatus = status;
            this.lastDate = date;
        } else if (status.isWorseThan(this.lastStatus)) {
            this.lastName = string;
            this.lastStatus = status;
            this.lastDate = date;
        }
    }

    @Override
    public Status getStatus() {
        return this.lastStatus;
    }

    @Override
    public String getProjectName() {
        return this.lastName;
    }

    @Override
    public String getBuildDate() {
        return this.dateFormat.format(this.lastDate);
    }

    public String annotate() {
        return this.statusPatternMatcher.replaceAll("___STATUS[[[$0]]]STATUS___($1)___($2)___($3)___");
    }
}

