/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.action.RegexParser;
import at.kugel.tool.buildtray.config.CheckBusy;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.Status;
import java.util.regex.Matcher;

class RegexBusyParser
implements RegexParser {
    private final Matcher busyPatternMatcher;
    private final boolean updateStatus;

    public RegexBusyParser(Config config, String string) {
        if (config.getCheckBusy() != CheckBusy.IGNORE) {
            this.busyPatternMatcher = config.getBusyPattern().matcher(string);
            this.updateStatus = config.getCheckBusy() == CheckBusy.CHECK;
        } else {
            this.busyPatternMatcher = null;
            this.updateStatus = false;
        }
    }

    public boolean isBusy() {
        return this.busyPatternMatcher != null && this.busyPatternMatcher.find();
    }

    public boolean isUpdateStatus() {
        return this.updateStatus;
    }

    @Override
    public Status getStatus() {
        return Status.BUSY;
    }

    @Override
    public String getProjectName() {
        return this.busyPatternMatcher.group(1);
    }

    @Override
    public String getBuildDate() {
        return null;
    }

    public String annotate() {
        return this.busyPatternMatcher.replaceFirst("___BUSY[[[$0]]]BUSY___($1)___");
    }
}

