/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.action.ActionCommand;
import at.kugel.tool.buildtray.action.RegexBusyParser;
import at.kugel.tool.buildtray.action.RegexParser;
import at.kugel.tool.buildtray.action.RegexStatusParser;
import at.kugel.tool.buildtray.action.URLReader;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;
import at.kugel.tool.buildtray.status.Status;
import java.io.IOException;
import java.text.ParseException;

class RefreshCommand
extends ActionCommand {
    public RefreshCommand(Config config, SetStatusAble setStatusAble) {
        super(config, setStatusAble);
    }

    @Override
    protected void workTemplate() throws IOException, ParseException {
        this.updateBuildResult();
    }

    private void updateBuildResult() throws IOException, ParseException {
        String string = this.downloadBuildStatus();
        if (this.handleBusyProject(string)) {
            return;
        }
        this.handleRegularProjects(string);
    }

    private String downloadBuildStatus() throws IOException {
        return new URLReader(this.config).readPage();
    }

    private boolean handleBusyProject(String string) {
        RegexBusyParser regexBusyParser = new RegexBusyParser(this.config, string);
        if (regexBusyParser.isBusy()) {
            if (regexBusyParser.isUpdateStatus()) {
                this.updateStatusFrom(regexBusyParser);
            }
            return true;
        }
        return false;
    }

    private void updateStatusFrom(RegexParser regexParser) {
        Status status = regexParser.getStatus();
        String string = regexParser.getProjectName();
        String string2 = regexParser.getBuildDate();
        this.statusDisplay.setStatus(status, string, string2);
    }

    private void handleRegularProjects(String string) throws ParseException {
        RegexStatusParser regexStatusParser = new RegexStatusParser(this.config, string);
        regexStatusParser.parse();
        this.updateStatusFrom(regexStatusParser);
    }
}

