/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.action.Actions;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PopupBuilder {
    private final PopupMenu popup = new PopupMenu();
    private final Actions actions;

    public PopupBuilder(Actions actions) {
        this.actions = actions;
    }

    public PopupMenu create() {
        this.addBrowse();
        this.addRefresh();
        this.addDisplay();
        this.addSeparator();
        this.addConfig();
        this.addSeparator();
        this.addExit();
        return this.popup;
    }

    private void addBrowse() {
        this.addEntry("open build server in web browser", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupBuilder.this.actions.openBrowser();
            }
        });
    }

    private void addEntry(String string, ActionListener actionListener) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(actionListener);
        this.popup.add(menuItem);
    }

    private void addRefresh() {
        this.addEntry("refresh build status now", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupBuilder.this.actions.refresh();
            }
        });
    }

    private void addDisplay() {
        this.addEntry("display annotated server response", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupBuilder.this.actions.showServerResponse();
            }
        });
    }

    private void addSeparator() {
        this.popup.addSeparator();
    }

    private void addConfig() {
        this.addEntry("edit current configuration and reload", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupBuilder.this.actions.editConfiguration();
            }
        });
    }

    private void addExit() {
        this.addEntry("exit", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupBuilder.this.actions.exit();
            }
        });
    }
}

