/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.action.ActionCommand;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;
import at.kugel.tool.buildtray.util.DesktopOperation;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

class OpenBrowserCommand
extends ActionCommand {
    public OpenBrowserCommand(Config config, SetStatusAble setStatusAble) {
        super(config, setStatusAble);
    }

    @Override
    protected void workTemplate() throws IOException {
        this.openDesktopBrowser();
    }

    private void openDesktopBrowser() throws IOException {
        new DesktopOperation(Desktop.Action.BROWSE){

            @Override
            public void runWithDesktop(Desktop desktop) throws IOException {
                desktop.browse(OpenBrowserCommand.this.createDisplayUri());
            }
        }.run();
    }

    private URI createDisplayUri() throws IOException {
        try {
            return this.determineDisplayUrl().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
    }

    private URL determineDisplayUrl() {
        URL uRL = this.config.getServerDisplayUrl();
        if (uRL == null) {
            uRL = this.config.getServerlUrl();
        }
        return uRL;
    }
}

