/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray.action;

import at.kugel.tool.buildtray.action.ActionCommand;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.status.SetStatusAble;
import at.kugel.tool.buildtray.util.DesktopOperation;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

class EditConfigurationCommand
extends ActionCommand {
    public EditConfigurationCommand(Config config, SetStatusAble setStatusAble) {
        super(config, setStatusAble);
    }

    @Override
    protected void workTemplate() throws IOException {
        this.openConfigFile();
    }

    private void openConfigFile() throws IOException {
        try {
            this.openConfigInEditor();
        }
        catch (IOException iOException) {
            this.openConfigInNotepad();
        }
    }

    private void openConfigInEditor() throws IOException {
        new DesktopOperation(Desktop.Action.EDIT){

            @Override
            public void runWithDesktop(Desktop desktop) throws IOException {
                desktop.edit(EditConfigurationCommand.this.configurationFile());
            }
        }.run();
    }

    private File configurationFile() {
        return this.config.getConfigFileLocation();
    }

    private void openConfigInNotepad() throws IOException {
        new ProcessBuilder("notepad.exe", this.configurationFile().toString()).start();
    }
}

