/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray;

import at.kugel.tool.buildtray.action.Actions;
import at.kugel.tool.buildtray.action.PopupBuilder;
import at.kugel.tool.buildtray.status.Status;
import at.kugel.tool.buildtray.status.TrayIconStatus;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;

public class TrayIconFactory {
    private final Status initialStatus = Status.BUSY;
    private final String initialTip = "Build Status Tray";
    private EnumMap<Status, Image> images;
    private TrayIcon trayIcon;

    public TrayIconFactory() {
        this.loadImages();
        this.createTrayIcon();
    }

    private void loadImages() {
        this.images = new EnumMap(Status.class);
        this.images.put(Status.OK, this.loadImage("res/build_green.gif"));
        this.images.put(Status.BUSY, this.loadImage("res/build_white.gif"));
        this.images.put(Status.FAILED, this.loadImage("res/build_red.gif"));
    }

    private Image loadImage(String string) {
        return Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string));
    }

    private void createTrayIcon() {
        Image image = this.images.get((Object)this.initialStatus);
        this.trayIcon = new TrayIcon(image, "Build Status Tray");
    }

    public TrayIconStatus create(Actions actions) throws AWTException {
        this.setRightClickPopup(actions);
        this.setLeftClickDefault(actions);
        this.addToSystemTray();
        return new TrayIconStatus(this.trayIcon, this.images);
    }

    private void setRightClickPopup(Actions actions) {
        PopupMenu popupMenu = new PopupBuilder(actions).create();
        this.trayIcon.setPopupMenu(popupMenu);
    }

    private void setLeftClickDefault(final Actions actions) {
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                actions.openBrowser();
            }
        });
    }

    private void addToSystemTray() throws AWTException {
        SystemTray systemTray = SystemTray.getSystemTray();
        systemTray.add(this.trayIcon);
    }
}

