/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray;

import at.kugel.tool.buildtray.TrayIconFactory;
import at.kugel.tool.buildtray.action.Actions;
import at.kugel.tool.buildtray.action.HtmlRegularExpressionActions;
import at.kugel.tool.buildtray.config.ReloadingConfig;
import at.kugel.tool.buildtray.status.TrayIconStatus;
import java.awt.AWTException;
import java.awt.SplashScreen;
import java.awt.SystemTray;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public final class Main {
    public static void main(String[] stringArray) throws AWTException, InterruptedException {
        Main.handleTrayNotSupported();
        Main.handleEmptyArguments(stringArray);
        String string = stringArray[0];
        ReloadingConfig reloadingConfig = new ReloadingConfig(string);
        HtmlRegularExpressionActions htmlRegularExpressionActions = new HtmlRegularExpressionActions(reloadingConfig);
        TrayIconStatus trayIconStatus = new TrayIconFactory().create(htmlRegularExpressionActions);
        htmlRegularExpressionActions.setStatusDisplay(trayIconStatus);
        Main.setUpRefreshTimer(reloadingConfig.getPollingMs(), htmlRegularExpressionActions);
        Main.closeSplashScreen(reloadingConfig.getSplashWaitMs());
    }

    private static void handleTrayNotSupported() {
        if (!SystemTray.isSupported()) {
            System.err.println("System Tray not supported");
            System.exit(1);
        }
    }

    private static void handleEmptyArguments(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: java -jar BuildServerSystemTray.jar <path to config file, e.g. \"config/Hudson-1.2.properties\">");
            System.exit(2);
        }
    }

    private static void setUpRefreshTimer(long l, final Actions actions) {
        Timer timer = new Timer("Build Server Polling", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                actions.refresh();
            }
        }, new Date(), l);
    }

    private static void closeSplashScreen(long l) throws InterruptedException {
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen != null) {
            Thread.sleep(l);
            splashScreen.close();
        }
    }
}

