/*
 * Decompiled with CFR 0.152.
 */
package at.kugel.tool.buildtray;

import at.kugel.tool.buildtray.action.HtmlRegularExpressionActions;
import at.kugel.tool.buildtray.action.URLReader;
import at.kugel.tool.buildtray.config.Config;
import at.kugel.tool.buildtray.config.ReloadingConfig;
import at.kugel.tool.buildtray.status.ConsoleStatus;

public final class CheckConfig {
    public static void main(String[] stringArray) {
        CheckConfig.handleEmptyArguments(stringArray);
        String string = stringArray[0];
        ReloadingConfig reloadingConfig = new ReloadingConfig(string);
        CheckConfig.tryServerAccess(reloadingConfig);
        CheckConfig.checkBuildStatus(reloadingConfig);
    }

    private static void handleEmptyArguments(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: java -jar BuildServerSystemTray.jar <path to config file, e.g. \"config/Hudson-1.2.properties\">");
            System.exit(2);
        }
    }

    private static void tryServerAccess(Config config) {
        System.out.println("checking server access...");
        try {
            String string = new URLReader(config).readPage();
            System.out.println(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private static void checkBuildStatus(Config config) {
        System.out.println("checking build status...");
        HtmlRegularExpressionActions htmlRegularExpressionActions = new HtmlRegularExpressionActions(config);
        htmlRegularExpressionActions.setStatusDisplay(new ConsoleStatus());
        htmlRegularExpressionActions.refresh();
    }
}

